import some.ColumnInfo;
import some.TableInfo;
import some.SQLCreator;

import net.w_horse.excelpojo.ExcelPOJOBridge;
import net.w_horse.excelpojo.ExcelPOJOException;

import org.apache.log4j.xml.DOMConfigurator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;


public class SampleClient {

	private String someProperty;

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		DOMConfigurator.configure("config/log4j.xml");

		SampleClient me = new SampleClient();
		me.createSQL();
	}
	public void createSQL() {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/TableDef.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("TableDefMember");

		TableInfo tableInfo = null;
		try {
			tableInfo = (TableInfo)bridge.load(
					"./files/upload/e[u`_}X^.xls",
					"e[u݌v");
		} catch (ExcelPOJOException e) {
			e.printStackTrace();
		}

		System.out.println("\n####################\n");
		System.out.println(tableInfo.toString());
		for (String key : tableInfo.getColumnMap().keySet()) {
			ColumnInfo column = tableInfo.getColumnMap().get(key);
			System.out.println(column.toString());
		}
		System.out.println("vC}[L[");
		for (String pKey : tableInfo.getPrimaryKeyMap().keySet()) {
			ColumnInfo column = tableInfo.getColumnMap().get(pKey);
			System.out.println(column.toString());
		}
		System.out.println("\n####################\n");

		SQLCreator sqlCreator = new SQLCreator();
		System.out.println(sqlCreator.create(tableInfo));

		System.out.println("\n####################\n");
	}


}
